/*
 * Decompiled with CFR 0.152.
 */
package evercookie;

import evercookie.EvercookieBackend;
import evercookie.EvercookieFileBackend;
import evercookie.EvercookieJnlpBackend;
import java.applet.Applet;
import java.awt.HeadlessException;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvercookieApplet
extends Applet {
    private static final long serialVersionUID = 1L;
    private static final EvercookieBackend[] backends = new EvercookieBackend[]{new EvercookieFileBackend(), new EvercookieJnlpBackend()};
    private final Hashtable<String, String> data = new Hashtable();
    private boolean workingBackends = false;

    @Override
    public void init() {
        for (EvercookieBackend backend : backends) {
            if (!backend.isAvailable()) continue;
            this.workingBackends = true;
            break;
        }
        if (!this.workingBackends) {
            System.out.println("Initialization failed. No working backends.");
            return;
        }
        this.load(this.data);
        System.out.println("Initialization complete. Cache has " + this.data.size() + " entries.");
        super.init();
    }

    public String get(String name) {
        return this.data.get(name);
    }

    public void set(String name, String value) {
        this.data.put(name, value);
        this.save(this.data);
    }

    private void save(Map<String, String> values) {
        if (!this.workingBackends) {
            return;
        }
        for (EvercookieBackend backend : backends) {
            if (!backend.isAvailable()) continue;
            backend.save(values);
            System.out.println(backend.getClass().getSimpleName() + ": saved: " + this.data.toString());
        }
    }

    private void load(Map<String, String> data) {
        if (!this.workingBackends) {
            return;
        }
        data.clear();
        for (EvercookieBackend backend : backends) {
            if (!backend.isAvailable()) continue;
            backend.load(data);
            System.out.println(backend.getClass().getSimpleName() + ": loaded: " + data.toString());
        }
    }

    public void cleanup() {
        if (!this.workingBackends) {
            return;
        }
        for (EvercookieBackend backend : backends) {
            if (!backend.isAvailable()) continue;
            backend.cleanup();
            System.out.println(backend.getClass().getSimpleName() + ": cleaned up.");
        }
    }
}

